#!/bin/sh

## Variablen ##
SCRIPTVERSION=9
STARTDATE="$(date +%a.%d.%b.%Y-%H:%M:%S)"
BOXIP="http://127.0.0.1"
WGET=/usr/bin/wget
EXTRACT="tar -xvzf"
EXTRACT_ZIP=/usr/bin/7za
NICE=/bin/nice
NICE_ARGS="-n 19"
TARGET_PATH=/usr/lib/enigma2/python/Plugins/Extensions
TMP=/var/volatile/tmp
WORKDIR=/home/root/_workdir # Beliebig aenderbar z.b: auf HDD zu /media/hdd/_workdir oder halt /media/hdd/dirname_nach_wunsch.
LOGFILE=$WORKDIR/_e2iplayer_install.log

# Falls bereits ein E2iPlayer installiert ist, wird der gebackuppt, will man das nicht einfach zu BACKUP=no aendern.
BACKUP=yes
# Verzeichnis wo das E2iPlayer Backup abgelegt wird (diese Variable nicht aendern).
E2IPLAYER_BACKUP_DIR=$WORKDIR/e2iplayer_backups

# Hier die E2iPlayer Version waehlen welche installiert/aktualisiert werden soll z.b: JBLEYEL_VERSION=yes
# (es darf nur eine der verschiedenen möglichen Versionen mit yes gekennzeichnet werden, naemlich die gewuenschte Version).
# fuer jbleyel E2iPlayer Version (funktioniert nur bei python3, also ab OpenATV-7.x aufwaerts).
JBLEYEL_VERSION=no
# fuer zadmario E2iPlayer Version (funktioniert sowohl bei python2 als auch bei python3, also fuer alle OpenATV Versionen).
ZADMARIO_VERSION=yes
# fuer Blindspot76 E2iPlayer 'python3' Version (funktioniert nur bei python3, also ab OpenATV-7.x aufwaerts).
BLINDSPOT76_PY3_VERSION=no
# fuer Blindspot76 E2iPlayer 'python2' Version (funktioniert nur bei python2, also bis zu OpenATV-6.4).
BLINDSPOT76_PY2_VERSION=no


# Arbeits + Backupverzeichnis falls noch nicht vorhanden erstellen (darin landen das Backup, das Logfile und die Fixes).
mkdir -p $WORKDIR/e2iplayer_backups


# Generelles Logging.
exec 3>&1 4>&2
trap 'exec 2>&4 1>&3' 0 1 2 3
exec 1>$LOGFILE 2>&1


# Konsole (OSD Fenster am TV) automatisch schliessen, damit man das bei der
# Ausfuehrung dieses Scripts direkt an der Box per Hotkey nicht selbst tun muss.
sleep 1
$WGET -q -O - $BOXIP/web/remotecontrol?command=174 > /dev/null


# Scriptpfad + Scriptname + Scriptversion Ausgabe + E2iPlayer Installation Startmeldung.
echo -e "\nScript-Pfad/Name/Version -> ${0}\t  Version_$SCRIPTVERSION\n"
echo -e "\nInstalliere/Aktualisiere E2iPlayer ... -> $STARTDATE\n\n"
$WGET -O - -q "$BOXIP/web/message?text=Starte%20Installation%20bzw%2E%20Aktualisierung%0AE2iPlayer \
%20%2E%2E%2E%20->%20$STARTDATE&type=1&timeout=10" > /dev/null && sleep 12


# OSD Fehler Ausgabe.
osd_error_message() {
	$WGET -O - -q "$BOXIP/web/message?text=ABBRUCH%20---%20(%20Details%20dazu%20in%20$LOGFILE%20)&type=3" > /dev/null
}


# Falls das Script schon einmal lief aber mit einem Fehler beendet wurde, eventuelle Reste loeschen.
$NICE $NICE_ARGS rm -rf $TMP/e2iplayer-* $TMP/e2iPlayer-* $TMP/iptv-host-xxx* $TMP/python*.gz $TMP/master.zip


# Bei Bedarf benoetigte Plugins/Programme nachinstallieren wie e2iplayer-deps, ppanel, p7zip/7zip, python-pycurl.
E2IPLAYER_DEPS=enigma2-plugin-extensions-e2iplayer-deps
PPANEL=enigma2-plugin-extensions-ppanel
if opkg list | grep -q p7zip ; then
	P7ZIP=p7zip && echo -e "P7ZIP=$P7ZIP\n"
elif opkg list | grep -q 7zip ; then
	P7ZIP=7zip && echo -e "P7ZIP=$P7ZIP\n"
fi
PY2_PYCURL=python-pycurl
PY3_PYCURL=python3-pycurl
if opkg list | grep -q $PY2_PYCURL ; then
	PYCURL=$PY2_PYCURL && echo -e "PYCURL=$PY2_PYCURL\n"
elif opkg list | grep -q $PY3_PYCURL ; then
	PYCURL=$PY3_PYCURL && echo -e "PYCURL=$PY3_PYCURL\n"
fi

OPKG_UPDATE=no
for i in $E2IPLAYER_DEPS $PPANEL $P7ZIP $PYCURL ; do
	if ! opkg list-installed | grep -q $i ; then
						
		if [ "$OPKG_UPDATE" = "no" ] ; then
			OPKG_UPDATE=yes ; echo -e "\nStarte opkg update ...\n"
			opkg update ; echo -e "\n"
		fi
		
		echo -e "$i fehlt.\nInstalliere $i  ...\n"
		opkg install $i 2> /dev/null
			
		if [ "$?" = "0" ] ; then
			echo -e "\n$i erfolgreich installiert.\n\n"
		else
			echo -e "\n... FEHLER ...\n$i installieren fehlgeschlagen !"
			echo -e "$i manuell mit Befehl;\nopkg install $i\ninstallieren und/oder $0 erneut starten.\n\n"
			osd_error_message && exit 1
		fi
	fi
done

# Image Distro auslesen (z.b: ob OpenATV oder OpenPLI) da es im OpenPLI bei Verwendung der E2iPlayer Version von zadmario
# ein Problem mit "nicht gefundener OpenSSL" geben kann, was mit der Installation von libcrypto-compat zu beheben geht.
DISTROVERSION="$($WGET -O - -q $BOXIP/web/deviceinfo | grep "\(<\|</\)e2distroversion" \
 | tr -d '\n' | sed "s/.*<e2distroversion>\(.*\)<\/e2distroversion>.*/\\1\n/")"
LIBCRYPTO_COMPAT="$(opkg info libcrypto-compat* | grep "Package:" | grep -v '\(-dbg\|-dev\|-staticdev\)' | awk {'print $NF'})"

# Wenn die Image Distro ein OpenPLI ist, bei Bedarf das Paket libcrypto-compat nachinstallieren.
if [ "$DISTROVERSION" = "openpli" ] ; then
	if ! opkg list-installed | grep -q "$LIBCRYPTO_COMPAT" ; then
		echo -e "Image Distro = \"$DISTROVERSION\",\n$LIBCRYPTO_COMPAT fehlt.\nInstalliere $LIBCRYPTO_COMPAT ...\n\n"
		
		if [ "$OPKG_UPDATE" = "yes" ] ; then
			opkg install $LIBCRYPTO_COMPAT
		else
			opkg update && opkg install $LIBCRYPTO_COMPAT
		fi
		
		if [ "$?" = "0" ] ; then
			echo -e "\n$LIBCRYPTO_COMPAT erfolgreich installiert.\n\n"
		else
			echo -e "\n... FEHLER ...\n$LIBCRYPTO_COMPAT installieren fehlgeschlagen !"
			echo -e "$LIBCRYPTO_COMPAT manuell mit Befehl;\nopkg install $LIBCRYPTO_COMPAT\ninstallieren und/oder $0 erneut starten.\n\n"
			osd_error_message && exit 1
		fi
	fi
fi


# Python Version checken (um fuer die Install/Aktualisierung zw. bis zu OpenATV-6.4 und ab OpenATV-7.0 zu unterscheiden).
PYTHON_VERSION_COMPLETE=$(python -c 'import sys; print(".".join(map(str, sys.version_info[:3])))')
echo -e "Python Version = $PYTHON_VERSION_COMPLETE\n\n"
PYTHON_VERSION=$(python -c "import sys; print(sys.version_info.major)")


# File Adresse fuer Download bestimmen anhand der Variablen oben in Zeile 23, 25, 27, und 29.
# Ausserdem pruefen ob die gewaehlte E2iPlayer Version zum Image (python2/python3) passt.
case "yes" in
	"$JBLEYEL_VERSION")
		echo "Gewaehlt -> E2iPlayer Version von jbleyel fuer python3."
		if [ $PYTHON_VERSION -ne 3 ] ; then
			echo -e "\n... FEHLER ...\nE2iPlayer Version passt nicht zu einem python$PYTHON_VERSION Image.\n\n"
			osd_error_message && exit 1
		fi
		#FILE_ADRESS=https://github.com/oe-mirrors/e2iplayer/archive/refs/heads/python3.zip
		FILE_ADRESS=https://github.com/oe-mirrors/e2iplayer/archive/refs/heads/python3.tar.gz
	;;
	"$ZADMARIO_VERSION")
		echo "Gewaehlt -> E2iPlayer von zadmario."
		#FILE_ADRESS=https://gitlab.com/zadmario/e2iplayer/-/archive/master/e2iplayer-master.zip
		FILE_ADRESS=https://gitlab.com/zadmario/e2iplayer/-/archive/master/e2iplayer-master.tar.gz
	;;
	"$BLINDSPOT76_PY3_VERSION")
		echo "Gewaehlt -> E2iPlayer Version von blindspot76 fuer python3."
		if [ $PYTHON_VERSION -ne 3 ] ; then
			echo -e "\n... FEHLER ...\nE2iPlayer Version passt nicht zu einem python$PYTHON_VERSION Image.\n\n"
			osd_error_message && exit 1
		fi
		FILE_ADRESS=https://github.com/Blindspot76/e2iPlayer-Python3/archive/refs/heads/master.zip
	;;
	"$BLINDSPOT76_PY2_VERSION")
		echo "Gewaehlt -> E2iPlayer von blindspot76 fuer python2."
		if [ $PYTHON_VERSION -eq 3 ] ; then
			echo -e "\n... FEHLER ...\nE2iPlayer Version passt nicht zu einem python$PYTHON_VERSION Image.\n\n"
			osd_error_message && exit 1
		fi
		FILE_ADRESS=https://github.com/Blindspot76/e2iPlayer/archive/refs/heads/master.zip
	;;
		*) echo -e "\n... FEHLER ...\nKeine E2iPlayer Version Auswahl getroffen.\n\n"; osd_error_message && exit 1;;
esac

# E2iPlayer Source Paket in das Verzeichnis (Variable TMP) downloaden.
echo -e "\n\nDownloade E2iPlayer Source Paket (*.tar.gz/*.zip) nach;\n$TMP ...\n"
if ! $WGET -P $TMP $FILE_ADRESS ; then
	if ! $WGET "--no-check-certificate" $FILE_ADRESS -P $TMP ; then
		echo -e "\n... FEHLER ...\nDownload E2iPlayer Source Paket fehlgeschlagen ! \nInternet Verbindung pruefen\nund $0 erneut starten.\n\n"
		osd_error_message && exit 1
	fi
fi

# E2iPlayer Source Paket im Verzeichnis (Variable TMP) entpacken.
echo -e "\nEntpacke E2iPlayer Source Paket nach;\n$TMP ..."
if [ -e $TMP/python3.tar.gz ] ; then
	$EXTRACT $TMP/python3.tar.gz -C /$TMP > /dev/null
elif [ -e $TMP/e2iplayer-master.tar.gz ] ; then
	$EXTRACT $TMP/e2iplayer-master.tar.gz -C /$TMP > /dev/null
elif [ -e $TMP/master.zip ] ; then
	$EXTRACT_ZIP x $TMP/master.zip -o$TMP > /dev/null
fi

if [ "$?" != "0" ] ; then
	echo -e "\n... FEHLER ...\nEntpacken E2iPlayer Source Paket fehlgeschlagen ! \n$0 erneut starten.\n\n"
	osd_error_message && exit 1
fi

# Pfad zum entpackten E2iPlayer Source Paket auslesen und einer Variablen zuweisen.
EXTRACTED_SOURCE_PATH="$($NICE $NICE_ARGS find $TMP -maxdepth 2 -name IPTVPlayer)"

# Einen bereits installierten E2iPlayer loeschen, wobei jedoch ein bereits installiertes E2iPlayer +18 Addon erhalten bleibt, wenn in Zeile 16 BACKUP=yes
# gesetzt ist wird vom bereits installierten E2iPlayer erst noch ein Backup (*.tar.gz) erstellt und im Verzeichnis (Variable E2IPLAYER_BACKUP_DIR) abgelegt.
if [ -d $TARGET_PATH/IPTVPlayer ] ; then

	if [ "$BACKUP" = "yes" ] ; then
		BACKUP_DATE=$(date +%d.%m.%Y-%H:%M:%S)
		echo -e "\n\nBackuppe den bereits installierten E2iPlayer in;\n$E2IPLAYER_BACKUP_DIR\nals Paket;\ne2iplayer-$BACKUP_DATE.tar.gz ..."
		#$NICE $NICE_ARGS tar cfvzp e2iplayer-$BACKUP_DATE.tar.gz -C $E2IPLAYER_BACKUP_DIR $TARGET_PATH/IPTVPlayer > /dev/null 2>&1
		$NICE $NICE_ARGS tar -czpf $E2IPLAYER_BACKUP_DIR/e2iplayer-$BACKUP_DATE.tar.gz $TARGET_PATH/IPTVPlayer > /dev/null 2>&1
	
		if [ "$?" != "0" ] ; then
			echo -e "\n... INFORMATION ...\nBackup des bereits installierten E2iPlayer fehlgeschlagen ! \nIst jedoch nicht weiter tragisch.\n"
		fi
	fi

	echo -e "\n\nLoesche den bereits installierten E2iPlayer in;\n$TARGET_PATH/IPTVPlayer ..."
	echo -e "Ein bereits installiertes E2iPlayer +18 Addon bleibt jedoch erhalten.\n"
	#$NICE $NICE_ARGS find $TARGET_PATH/IPTVPlayer -type f ! -iname "*xxx*" -exec rm {} +
	$NICE $NICE_ARGS find $TARGET_PATH/IPTVPlayer -type f -iname "*xxx*" -o -delete
	
	if [ "$?" != "0" ] ; then
		echo -e "\n... INFORMATION ...\nLoeschen des bereits installierten E2iPlayer fehlgeschlagen ! \nIst jedoch moeglicherweise nicht weiter tragisch."
		echo -e "Der neue E2iPlayer wird somit einfach drueber kopiert.\n"
	fi
	
	# Nur wenn im bereits installierten E2iPlayer auch das +18 Addon mit dabei ist (also auch bereits installiert ist) werden die
	# +18 Addon Dateien im entpackten E2iPlayer Source Paket geloescht damit ein bereits installiertes +18 Addon nicht ueberschrieben wird.
	if [ "$($NICE $NICE_ARGS find $TARGET_PATH/IPTVPlayer -type f -iname "*xxx*" 2>/dev/null)" ] ; then
		echo -e "\n\nLoesche +18 Addon Dateien aus;\n$EXTRACTED_SOURCE_PATH"
		echo -e "um nachher beim Kopieren ein bereits installiertes\n+18 Addon nicht zu ueberschreiben ..."
		#$NICE $NICE_ARGS find $TMP/*/IPTVPlayer -maxdepth 3 -iname "*xxx*" -exec rm {} \;
		# Besser, da exakter Pfad angegeben ist und durch -type f ausserdem nur Dateien geloescht werden, obiges loescht auch Ordner mit xxx im Namen.
		#$NICE $NICE_ARGS find $EXTRACTED_SOURCE_PATH -maxdepth 3 -type f -iname "*xxx*" -exec rm {} \;
		# Effizienter als obiger Befehl und portabel (sollte also in jedem Linux funktionieren).
		#$NICE $NICE_ARGS find $EXTRACTED_SOURCE_PATH -maxdepth 3 -type f -iname "*xxx*" -exec rm {} + 
		# Am effizientesten wenn das find mit delete funktioniert (gibt glaube ich auch Versionen von find wo es delete nicht gibt, also nicht so portabel). 
		$NICE $NICE_ARGS find $EXTRACTED_SOURCE_PATH -maxdepth 3 -type f -iname "*xxx*" -delete
	fi
fi

# Verzeichnis (Variable TMP)/e2iplayer-*/IPTVPlayer bzw. (Variable EXTRACTED_SOURCE_PATH) rekursiv in das Verzeichnis (Variable TARGET_PATH) kopieren.
echo -e "\n\nKopiere;\n$EXTRACTED_SOURCE_PATH\nnach;\n$TARGET_PATH ...\n"
if ! $NICE $NICE_ARGS cp -rf $EXTRACTED_SOURCE_PATH $TARGET_PATH ; then
	echo -e "\n... FEHLER ...\nKopieren;\n$EXTRACTED_SOURCE_PATH fehlgeschlagen ! \n\n"
	osd_error_message && exit 1
fi


# Special keymap.xml (for @Papi2000 (ist auch gut fuer alle anderen User)) einspielen.
mv $TARGET_PATH/IPTVPlayer/keymap.xml $TARGET_PATH/IPTVPlayer/keymap.xml.org
$WGET -q -O "$TARGET_PATH/IPTVPlayer/keymap.xml" "https://drive.usercontent.google.com/download?id=1T9bS_NQC-z7YE-UQfm3b3V-mY2KY9css&export=download&confirm=yes"



# Folgendes (Fixes installieren gilt nur solange bis @zadmario die Fixes uebernimmt) !
# Fixes 2025 von Mister X fuer savefiles, Vidhide, vidoza, supervideo.cc, VOE, hdfilmetv und vieles mehr installieren, nur
# in der ZADMARIO_VERSION und in den BLINDSPOT76_VERSIONEN da in der JBLEYEL_VERSION bereits enthalten.
echo -e "\n\nFixes 2025 von Mister X installieren ..."
if [ "$JBLEYEL_VERSION" != "yes" ] ; then
	FDIR=$WORKDIR/e2iplayer_fixes && mkdir -p $FDIR
	
	rm -f $FDIR/e2iplayer_fixes.tar.gz
	
	# Download der Fixes (Paket "e2iplayer_fixes.tar.gz") aus Google Drive.
	$WGET -q -O "$FDIR/e2iplayer_fixes.tar.gz" "https://drive.usercontent.google.com/download?id=1-kgV9OUBMyrR3TTXQinGk1pwOneTOF5c&export=download&confirm=yes" && sleep 1

	# Entpacken der Fixes, gleich in die richtigen Verzeichnisse des E2iPlayers (gleichnamige Dateien dort werden ueberschrieben).
	$EXTRACT $FDIR/e2iplayer_fixes.tar.gz -C $TARGET_PATH > /dev/null
	
	if [ "$?" != "0" ] ; then
		echo -e '\n... FEHLER ...\nFixes entpacken bzw. kopieren fehlgeschlagen !\n\n'
		osd_error_message && exit 1
	fi
fi
echo -e "Fixes installieren erfolgreich beendet.\n\n"
# Ende Fixes installieren.



# E2iPlayer Installation/Aktualisierung Erfolgsmeldung.
ENDDATE="$(date +%a.%d.%b.%Y-%H:%M:%S)"
echo -e "\nE2iPlayer erfolgreich installiert/aktualisiert. -> $ENDDATE\n"
$WGET -O - -q "$BOXIP/web/message?text=E2iPlayer%20erfolgreich%20installiert%20bzw%2E%20aktualisiert%2E&type=1&timeout=10" > /dev/null


# Reste loeschen.
echo -e "\nLoesche Altlasten (*.tar.gz/*.zip und Ordner e2iplayer-*) ...\n"
$NICE $NICE_ARGS rm -rf $TMP/e2iplayer-* $TMP/e2iPlayer-* $TMP/python*.gz $TMP/master.zip


# Pruefen ob Aufnahme{n} laeuft/laufen, wenn nicht Enigma2-GUI Neustart einleiten, wenn doch Enigma2-GUI Neustart
# um TIMEOUT Minuten verschieben und das wiederholend so lange bis keine Aufnahme{n} mehr laeuft/laufen.
echo ""
sleep 11
TIMEOUT=10
z=1
REC=yes
while [ "$REC" = "yes" ] ; do
	if [ $($WGET -O- -q $BOXIP/web/timerlist | grep "<e2state>2</e2state>" | grep -cm 1 "2") = 1 ] ; then
		REC=yes
		echo -e "Kein Enigma2-GUI Neustart moeglich da eine Aufnahme laeuft -> Warte $TIMEOUT Minuten ...\n"
		
		if [ "$z" = "1" ] ; then
			MSG="$(echo -e "Kein Enigma2-Gui Neustart moeglich da eine Aufnahme\nlaeuft -> versuche es alle $TIMEOUT Minuten erneut ...")"
			$WGET -O - -q "$BOXIP/web/message?type=1&timeout=10&text=$MSG" > /dev/null
		fi
		
		z=$((z+1)) && sleep ${TIMEOUT}m
		echo -e "\nLeite Enigma2-GUI Neustart (Versuch $z) ein ...\n"
	else
		REC=no
		echo -e "Keine laufende Aufnahme -> Starte Enigma2-GUI neu ...\n"
		$WGET -O - -q "$BOXIP/web/message?text=Keine%20laufende%20Aufnahme%0AStarte%20Enigma2%2DGUI%20neu%20%2E%2E%2E&type=1&timeout=10" > /dev/null && sleep 12
	fi
done

$WGET -q -O - $BOXIP/web/powerstate?newstate=3 > /dev/null 2>&1


exit
#