#!/bin/bash

## Variablen ##
STARTDATE="$(date +%a.%d.%b.%Y-%H:%M:%S)"

BOXIP=http://localhost
WGET=/usr/bin/wget
CP=/bin/cp
SOURCE_PY3=iptv-host-xxx-master-python3
SOURCE_PY2=iptv-host-xxx-master
TARGET=/usr/lib/enigma2/python/Plugins/Extensions/IPTVPlayer
TMP=/tmp
LOGFILE=$TMP/e2ipl_xxx_inst_deinst.log


# Konsole (OSD Fenster am TV) schliessen.
sleep 1
$WGET -q -O - $BOXIP/web/remotecontrol?command=174 && sleep 2


# Generelles Logging.
exec 3>&1 4>&2
trap 'exec 2>&4 1>&3' 0 1 2 3
exec 1>$LOGFILE 2>&1


# Falls das Script erneut gestartet wird da es zuvor aus welchem Grund auch
# immer abgebrochen ist die eventuell verbliebenen Altlasten loeschen.
rm -f $TMP/iptv.tar.gz && rm -rf $TMP/iptv-host-xxx-*


# OSD Fehler Ausgabe.
osd_error_message() {
	$SLEEP 3
	$WGET -O - -q "$BOXIP/web/message?text=ABBRUCH%20---%20(%20Details%20dazu%20in%20$LOGFILE%20)&type=3" > /dev/null
	echo ""
}


# Deinstalltions Part (Script ist ein Toggle Script (kann also abwechselnd installieren und deinstallieren)).
for_deinstall() {
CHECK_FILE_1=$TARGET/hosts/hostxxx.pyc
CHECK_FILE_2=$TARGET/hosts/hostXXX.pyc
CHECK_FILE_3=$TARGET/hosts/hostXXX.pyo

if [ -e $CHECK_FILE_1 -o -e $CHECK_FILE_2 -o -e $CHECK_FILE_3 ] ; then
	$WGET -O - -q "$BOXIP/web/message?text=Starte%20E2iPlayer%20%2B18%20Addon%20Deinstallation%20%2E%2E%2E%20 \
	%0A%20%20%20%20%20%20%20$STARTDATE&type=1&timeout=10" > /dev/null && sleep 12
	echo -e "\nStarte -> Deinstallation E2iPlayer +18 Addon ...\n"
	
	PY3_FILE=$TARGET/hosts/hostxxx.py
	PY2_FILE=$TARGET/hosts/hostXXX.py
	PNG_FILE_1=$TARGET/icons/logos/XXXlogo.png
	PNG_FILE_2=$TARGET/icons/PlayerSelector/xxx100.png
	PNG_FILE_3=$TARGET/icons/PlayerSelector/xxx120.png
	PNG_FILE_4=$TARGET/icons/PlayerSelector/xxx135.png
	PNG_FILE_5=$TARGET/icons/PlayerSelector/XXX100.png
	PNG_FILE_6=$TARGET/icons/PlayerSelector/XXX120.png
	PNG_FILE_7=$TARGET/icons/PlayerSelector/XXX135.png
	SH_FILE=$TARGET/iptvupdate/custom/xxx.sh
	
	for file in $CHECK_FILE_1 $CHECK_FILE_2 $CHECK_FILE_3 $PY3_FILE $PY2_FILE $PNG_FILE_1 \
				$PNG_FILE_2 $PNG_FILE_3 $PNG_FILE_4 $PNG_FILE_5 $PNG_FILE_6 $PNG_FILE_7 $SH_FILE ; do
				
				if [ -e $file ] ; then
					echo -e "\nLoesche $file ...\n" 
					rm $file
					
					if [ "$?" != "0" ] ; then
						echo -e "\n\n... FEHLER ...\nLoeschen der Datei;\n$file\nfehlgeschlagen ! "
						echo -e "Loesung: Diese Datei einfach manuell loeschen.\n\n"
						failed=yes
					fi
				fi
	done

	if [ "$failed" = "yes" ] ; then
		$WGET -O - -q "$BOXIP/web/message?text=FEHLER%20%2D%3E%20Anweisungen%20in%20$LOGFILE%20befolgen%20%21&type=2" > /dev/null
		exit 1
	else
		$WGET -O - -q "$BOXIP/web/message?text=Deinstallation%20E2iPlayer%20%2B18%20Addon%20erfolgreich%20beendet%2E&type=1&timeout=15" > /dev/null
		echo -e "\n\n... Deinstallation E2iPlayer +18 Addon erfolgreich beendet ! ...\n\n" && exit
	fi
fi
}


# Job Start mit Datum und Zeitangabe (wird in das Logfile geschrieben).
echo -e "\nJOB START -> $STARTDATE\n\n"


# Falls noch nicht installiert das Plugin ppanel (dieses braucht es fuer die korrekte Funktion wenn dieses Script via Hotkey gestartet werden soll)
# und das vollwertige wget installieren, da mit dem abgespeckten busybox-wget zumindest im OpenPLI keine wget Nachrichten ueber die WebIF Api gelingen.
for i in enigma2-plugin-extensions-ppanel wget ; do
	opkg list-installed | grep -q $i
	
	if [ "$?" != "0" ] ; then
		if [ "$OPKGUPD" = "yes" ] ; then
			echo -e "\nInstalliere $i ..." && opkg install $i
		else
			echo -e "\nStarte benoetigten opkg update ...\n" && OPKGUPD=yes && opkg update
			echo -e "\nInstalliere $i ..." && opkg install $i
		fi
			
		if [ "$?" = "0" ] ; then
			echo -e "\n$i erfolgreich installiert.\n"
		else
			echo -e "\n... ABBRUCH ...\n$i installieren fehlgeschlagen !"
			echo -e "$i manuell mit Befehl;\nopkg install $i\ninstallieren und/oder $0 erneut starten.\n\n" && exit 1
		fi
	fi
done


# Falls das E2iPlayer +18 Addon bereits installiert ist wirkt das Script nun als
# Deinstallations-Script, es greift also in diesem Fall der Deinstallations Part ab Zeile 41 - 85.
for_deinstall


echo -e "\nStarte -> Installation E2iPlayer +18 Addon ...\n"


# Job Start Meldung mit Datum und Zeitangabe (wird im OSD am TV angezeigt).
$WGET -O - -q "$BOXIP/web/message?text=Starte%20E2iPlayer%20%2B18%20Addon%20Installation%20%2E%2E%2E%20 \
%0A%20%20%20%20%20%20%20$STARTDATE&type=1&timeout=10" > /dev/null && sleep 12


# Pruefen ob der E2iPlayer installiert ist, denn der ist Voraussetzung um E2iPlayerXXX installieren zu koennen.
CHECK_DIR=$TARGET/scripts
if [ ! -d $CHECK_DIR ] ; then
	osd_error_message
	echo -e "\n... ABBRUCH ...\nBitte zuerst das Plugin E2iPlayer installieren ! \n\n" && exit 1
fi

# Pruefen ob python3 (ab OpenATV-7.x aufwaerts) laeuft. 
py_ver=$(python -c "import sys; print(sys.version_info.major)")

if [ $py_ver -eq 3 ] ; then
	DL_ARCHIVE=http://www.blindspot.nhely.hu/python3/iptv-host-xxx-master-python3.tar.gz
else
	DL_ARCHIVE=http://www.blindspot.nhely.hu/hosts/iptv-host-xxx-master.tar.gz
fi

# Download des *.tar.gz Archiv mit Namen (Variable PACKAGE) als (Variable NEW_PACKAGE) in das /tmp Verzeichnis.
PACKAGE=$(basename $DL_ARCHIVE)
NEW_PACKAGE=iptv.tar.gz
echo -e "\n\nDownloade Archiv;\n$PACKAGE\nals;\n$NEW_PACKAGE ...\n"
$WGET --no-check-certificate $DL_ARCHIVE -O $TMP/$NEW_PACKAGE && sleep 1
# oder stattdessen mit curl (im PLI klappte bei meinen Tests kein wget aber dafür curl), bei Verwendung von PLI oder wenns mal auch im
# OpenATV nicht klappen will dann also curl verwenden, dazu nur mit nem Linux Editor vor Zeile 148 das Zeichen # setzen und vor Zeile 152
# entfernen. Moeglich das curl auch erstmal installiert werden muss, dann also Befehl   opkg install curl   in telnet oder ssh.
#curl -o $TMP/$NEW_PACKAGE $DL_ARCHIVE && sleep 1
# EDIT -> neueste Tests zeigen das der Download nun auch im OpenPLI mit dem vollwertigen wget klappt, sogar mit dem
# busybox-wget doch wie oben schon erwaehnt klappen mit dem busybox-wget keine wget Nachrichten ueber die WebIF Api.

if [ ! -e $TMP/$NEW_PACKAGE ] ; then
	osd_error_message
	echo -e "\n... ABBRUCH ...\nDownload des Archiv $NEW_PACKAGE nach $TMP fehlgeschlagen ! "
	echo -e "Internet Verbindung pruefen und erneut versuchen.\n\n" && exit 1
fi

# Entpacken des iptv.tar.gz Archivs (Variable NEW_PACKAGE).
echo -e "\nEntpacke Archiv $TMP/$NEW_PACKAGE ...\n"
tar -xvzf $TMP/$NEW_PACKAGE -C $TMP

if [ -d $TMP/$SOURCE_PY3 ] ; then
	SOURCE=$SOURCE_PY3
elif [ -d $TMP/$SOURCE_PY2 ] ; then
	SOURCE=$SOURCE_PY2
else
	osd_error_message
	echo -e "\n\n... ABBRUCH ...\nEntpacken des Archiv $NEW_PACKAGE in $TMP fehlgeschlagen ! \n\n" && exit 1
fi

# Die entpackten Dateien aus dem Archiv iptv.tar.gz in die Zielordner kopieren.
echo ""
$CP -rf $TMP/$SOURCE/IPTVPlayer/icons $TARGET ; echo -e "\ncopy directory icons = $?"
$CP -rf $TMP/$SOURCE/IPTVPlayer/iptvupdate $TARGET ; echo "copy directory iptvupdate = $?"
$CP -rf $TMP/$SOURCE/IPTVPlayer/hosts $TARGET ; echo -e "copy directory hosts = $?\n"


# Job Endmeldung + Altlasten loeschen bei Erfolg.
echo -e "\n\n... Installation E2iPlayer +18 Addon erfolgreich beendet ! ...\n\n"
ENDDATE="$(date +%a.%d.%b.%Y-%H:%M:%S)" && echo -e "\nJOB ENDE -> $ENDDATE\n\n"
$WGET -O - -q "$BOXIP/web/message?text=Installation%20E2iPlayer%20%2B18%20Addon%20erfolgreich%20beendet%20%2E \
%20%0A%20%20%20%20%20%20%20$ENDDATE&type=1&timeout=10" > /dev/null
rm -f $TMP/iptv.tar.gz && rm -rf $TMP/$SOURCE && sleep 12


# Pruefen ob Aufnahme{n} laeuft/laufen, wenn nicht Enigma2-GUI-Neusstart einleiten, wenn doch Enigma2-GUI-Neusstart
# um 10 Minuten verschieben und das wiederholend so lange bis keine Aufnahme{n} mehr laeuft/laufen.
z=1
REC=yes
while [ "$REC" = "yes" ] ; do
	if [ $($WGET -O- -q $BOXIP/web/timerlist | grep "<e2state>2</e2state>" | grep -cm 1 "2") = 1 ] ; then
		REC=yes 
		echo -e "\nKein Enigma2-GUI-Neustart moeglich da eine Aufnahme laeuft -> Warte 10 Minuten ...\n"
		$WGET -O - -q "$BOXIP/web/message?text=Kein%20Enigma2%2DGUI%2DNeustart%20moeglich%2C%20da%20eine%0A \
        Aufnahme%20laeuft%20%2D%3E%20Warte%20%31%30%20Minuten%20%2E%2E%2E&type=2&timeout=10" > /dev/null
		z=$((z+1)) && sleep 10m
		echo -e "Leite Enigma2-GUI-Neustart (Versuch $z) ein ...\n"
	else
		REC=no
		$WGET -O - -q "$BOXIP/web/message?text=Keine%20laufende%20Aufnahme%0AStarte%20Enigma2%2DGUI%20neu%20%2E%2E%2E&type=1&timeout=10" > /dev/null && sleep 12
	fi
done

echo -e "Keine laufende Aufnahme -> Starte Enigma2-GUI neu ...\n"
$WGET -q -O - $BOXIP/web/powerstate?newstate=3


exit
