#!/bin/sh

## Variablen ##
MOVIEDIR="${*%/}"
NAME_PART="$(echo $MOVIEDIR | tr / _)"

# Hier die gewuenschten Filmformate (*.ts, *.avi, *.mkv, usw..) eintragen welche bei der Suche beruecksichtigt werden sollen.
# Zur Verfuegung stehen *.ts, *.mkv, *.mp4, *.avi, *.iso -> ist bei Bedarf jedoch beliebig erweiterbar. Von der Suche ausgeschlossen
# werden Filmformate indem man sie einfach auskommentiert also einfach eine Raute davor setzt z.b: #ISO="*.iso" fuer das *.iso Format.
#TS="*.ts"
MKV="*.mkv"
MP4="*.mp4"
#AVI="*.avi"
ISO="*.iso"

# Hier kann man bis zu 10 Verzeichnisse die von der Suche nach Filmen ausgeschlossen werden sollen eintragen. Ein Beispiel
# dazu koennte wie folgt aussehen -> EXCLUDED_DIR_1="/media/hdd/movie/Musik" usw.. fuer weitere auszuschliessende Verzeichnisse.
EXCLUDED_DIR_1="/media/hdd/movie/_For_Testing"
EXCLUDED_DIR_2="/media/hdd/movie/Musik"
EXCLUDED_DIR_3="/media/hdd/movie/__Streams"
EXCLUDED_DIR_4=""
EXCLUDED_DIR_5=""
EXCLUDED_DIR_6=""
EXCLUDED_DIR_7=""
EXCLUDED_DIR_8=""
EXCLUDED_DIR_9=""
EXCLUDED_DIR_10=""

STAT_CMD=(stat -c '%y %s %n') # array
NUMFMT_CMD=("numfmt --field=4 --to=iec-i") # array

# Standardmaessig wird fuer Datum, Groesse, Namen der Filme, das Programm stat sowie numfmt (um die Groesse menschenlesbar umzuwandeln)
# verwendet, will man stattdessen lieber das Programm ls verwenden ist die folgende Variable zu USE_STAT_AND_NUMFMT=no zu aendern.
# Sollte das Programm numfmt (ist in den coreutils mit dabei) jedoch nicht installiert sein und die Variable ist auf USE_STAT_AND_NUMFMT=yes
# eingestellt wird versucht die coreutils zu installieren, klappt das nicht wird trotz Einstellung USE_STAT_AND_NUMFMT=yes das Programm ls verwendet.
#USE_STAT_AND_NUMFMT=yes

LISTPATH=/home/root
MOVIELIST_WITH_PATH=movielist_with_path
MOVIELIST_WITHOUT_PATH=movielist_without_path


# Checks ob die Filmliste mit Pfad bzw. ohne Pfad erfogreich erstellt wurde.
check_movielist_with_path() {
if [ "$?" = "0" ] ; then
	echo -e "Filmliste incl. Pfade mit Namen;\n${MOVIELIST_WITH_PATH}($NAME_PART).txt\nwurde erstellt in;\n$LISTPATH\n"
fi		
}
check_movielist_without_path() {
if [ "$?" = "0" ] ; then
	echo -e "Filmliste ohne Pfade mit Namen;\n${MOVIELIST_WITHOUT_PATH}($NAME_PART).txt\nwurde erstellt in;\n$LISTPATH\n"
fi	
}


echo -e "MOVIE_PFAD = $MOVIEDIR\n"
echo -e "MOVIE_PFAD = $MOVIEDIR\n" > $LISTPATH/${MOVIELIST_WITH_PATH}\($NAME_PART\).txt
echo -e "MOVIE_PFAD = $MOVIEDIR\n" > $LISTPATH/${MOVIELIST_WITHOUT_PATH}\($NAME_PART\).txt


# Pruefen ob das Programm numfmt vorhanden ist, bzw. ob es auch verwendet werden soll, siehe Einstellung zur Variablen
# USE_STAT_AND_NUMFMT um den awk Befehl je nach dem verwendeten Programm (stat + numfmt oder stattdessen ls) festzulegen.
if which numfmt > /dev/null ; then
	if [ "$USE_STAT_AND_NUMFMT" = "yes" ] ; then
		AWK_CMD=(awk '{printf "%s\t%s %s\t%s", $1, $4; for(i=5; i<=NF; i++) printf "%s%s", OFS, $i; print ""}') # array
	else
		AWK_CMD=(awk '{printf "%s\t%s %s\t%s", $6, $5; for(i=9; i<=NF; i++) printf "%s%s", OFS, $i; print ""}') # array
	fi
else
	if [ "$USE_STAT_AND_NUMFMT" = "yes" ] ; then
		opkg update > /dev/null && opkg install coreutils > /dev/null
		
		if [ "$?" = "0" ] ; then
			AWK_CMD=(awk '{printf "%s\t%s %s\t%s", $1, $4; for(i=5; i<=NF; i++) printf "%s%s", OFS, $i; print ""}') # array
		else
			echo -e "Programm numfmt konnte nicht installiert\nwerden, verwende stattdessen das Programm ls.\n"
			USE_STAT_AND_NUMFMT=no
			AWK_CMD=(awk '{printf "%s\t%s %s\t%s", $6, $5; for(i=9; i<=NF; i++) printf "%s%s", OFS, $i; print ""}') # array
		fi
	else
		AWK_CMD=(awk '{printf "%s\t%s %s\t%s", $6, $5; for(i=9; i<=NF; i++) printf "%s%s", OFS, $i; print ""}') # array
	fi	
fi


# Gewuenschte Filmformate also *.ts, *.avi, *.mkv, usw.. in Array schreiben.
count=0
echo ""
for i in $TS $MKV $MP4 $AVI $ISO ; do
	count=$((count+1))
	echo "Suche Filme mit Format $i."   
	if [ "$count" -eq "1" ] ; then
		MOVIES+=( -name "$i" )
	elif [ "$count" -gt "1" ] ; then
		MOVIES+=( -o -name "$i" )
	fi
done

# Auszuschliessende Verzeichnisse in Array schreiben. 
count=0
for i in $EXCLUDED_DIR_1 $EXCLUDED_DIR_2 $EXCLUDED_DIR_3 $EXCLUDED_DIR_4 $EXCLUDED_DIR_5 \
$EXCLUDED_DIR_6 $EXCLUDED_DIR_7 $EXCLUDED_DIR_8 $EXCLUDED_DIR_9 $EXCLUDED_DIR_10 ; do
	count=$((count+1))
	echo -e "\nVerzeichnis -> $i\nwird von der Suche nach Filmen ausgeschlossen."   
	if [ "$count" -eq "1" ] ; then
		EXCLUDED_DIRS+=( -path "$i" )
	elif [ "$count" -gt "1" ] ; then
		EXCLUDED_DIRS+=( -o -path "$i" )
	fi
done

# Check ob ueberhaupt auszuschliessende Verzeichnisse konfiguriert wurden.
if ! (( ${#EXCLUDED_DIRS[@]} )); then
	NO_EXLUDED_DIRS=yes
	echo "Keine auszuschliessende Verzeichnisse konfiguriert."
fi


# Filmliste erstellen (je nach Konfiguration mit oder ohne ausgeschlossene Verzeichnisse).
echo -e "\n"
if [ "$NO_EXLUDED_DIRS" = "yes" ] ; then
	if [ "$USE_STAT_AND_NUMFMT" = "yes" ] ; then
		find "${MOVIEDIR}" -type f \( "${MOVIES[@]}" \) -print0 | xargs -0 "${STAT_CMD[@]}" \
		| ${NUMFMT_CMD[@]} | "${AWK_CMD[@]}" | sort -k3,3  >> $LISTPATH/${MOVIELIST_WITH_PATH}\($NAME_PART\).txt
		
		check_movielist_with_path	
		
		find "${MOVIEDIR}" -type f \( "${MOVIES[@]}" \) -exec bash -c 'printf "%s\t%s\t%s\t%s   \t%s\n" \
		$(stat -c " %y %s" "$1" | numfmt --field=4 --to iec) "$(basename "$1")"' - {} \; | sort -k5,5 | cut -f1,4,5 -d$'\t' \
		>> $LISTPATH/${MOVIELIST_WITHOUT_PATH}\($NAME_PART\).txt
	
		check_movielist_without_path	
	else
		# Mit ls anstatt mit stat und numfmt (also keine coreutils wegen numfmt noetig).
		find "${MOVIEDIR}" -type f \( "${MOVIES[@]}" \) -print0 | xargs -0 ls -lh --full-time | sort -k9,9 \
		| "${AWK_CMD[@]}" >> $LISTPATH/${MOVIELIST_WITH_PATH}\($NAME_PART\).txt
		
		check_movielist_with_path
		
		find "${MOVIEDIR}" -type f \( "${MOVIES[@]}" \) -print0 | xargs -0 ls -lh --full-time \
		| sed -e 's#/.*/##' | "${AWK_CMD[@]}" | sort -k3 >> $LISTPATH/${MOVIELIST_WITHOUT_PATH}\($NAME_PART\).txt		
		
		check_movielist_without_path	
	fi
else
	if [ "$USE_STAT_AND_NUMFMT" = "yes" ] ; then
		find "${MOVIEDIR}" \( "${EXCLUDED_DIRS[@]}" \) -prune -o -type f \( "${MOVIES[@]}" \) -print0 | xargs -0 "${STAT_CMD[@]}" \
		| ${NUMFMT_CMD[@]} | "${AWK_CMD[@]}" | sort -k3,3  >> $LISTPATH/${MOVIELIST_WITH_PATH}\($NAME_PART\).txt
		#find "${MOVIEDIR}" \( "${EXCLUDED_DIRS[@]}" \) -prune -o -type f \( "${MOVIES[@]}" \) -exec bash -c 'printf "%s\t%s\t%s\t%s\n" \
		#$(stat -c " %.10y %s" "$1" | numfmt --field=2 --to=iec-i) "$1"' - {} \; | sort -k3,3 > $LISTPATH/${MOVIELIST_WITH_PATH}\($NAME_PART\).txt
		
		check_movielist_with_path
		
		find "${MOVIEDIR}" \( "${EXCLUDED_DIRS[@]}" \) -prune -o -type f \( "${MOVIES[@]}" \) -exec bash -c 'printf "%s\t%s\t%s\t%s   \t%s\n" \
		$(stat -c " %y %s" "$1" | numfmt --field=4 --to iec) "$(basename "$1")"' - {} \; | sort -k5,5 | cut -f1,4,5 -d$'\t' \
		>> $LISTPATH/${MOVIELIST_WITHOUT_PATH}\($NAME_PART\).txt
	
		check_movielist_without_path	
	else
		# Mit ls anstatt mit stat und numfmt (also keine coreutils wegen numfmt noetig).
		find "${MOVIEDIR}" \( "${EXCLUDED_DIRS[@]}" \) -prune -o -type f \( "${MOVIES[@]}" \) -print0 | xargs -0 ls -lh --full-time | sort -k9,9 \
		| "${AWK_CMD[@]}" >> $LISTPATH/${MOVIELIST_WITH_PATH}\($NAME_PART\).txt
		
		check_movielist_with_path
		
		find "${MOVIEDIR}" \( "${EXCLUDED_DIRS[@]}" \) -prune -o -type f \( "${MOVIES[@]}" \) -print0 | xargs -0 ls -lh --full-time \
		| sed -e 's#/.*/##' | "${AWK_CMD[@]}" | sort -k3 >> $LISTPATH/${MOVIELIST_WITHOUT_PATH}\($NAME_PART\).txt
		
		check_movielist_without_path
	fi
fi


exit
