#!/bin/sh

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share
stbcheck=`cat /proc/stb/info/boxtype`

# workaround for corrupt ssl files
if ! grep ^config.misc.firstrun=false /etc/enigma2/settings >/dev/null; then
	rm -rf /etc/enigma2/cert.pem &
	rm -rf /etc/enigma2/key.pem &
fi

if [ -e /proc/stb/info/boxtype ]; then
	if [ $stbcheck == "sf8008" ] || [ $stbcheck == "sf8008m" ] || [ $stbcheck == "sx988" ] || [ $stbcheck == "ip8" ] || [ $stbcheck == "ustym4kpro" ] || [ $stbcheck == "cc1" ] || [ $stbcheck == "trio4k" ] || [ $stbcheck == "gbip4k" ] || [ $stbcheck == "gbmv200" ] || [ $stbcheck == "sfx6008" ] || [ $stbcheck == "sx88v2" ]; then
		count=`ps -ef |grep libreader |grep -v "grep" |wc -l`
		if [ 0 == $count ];then
			libreader 720P_50
		fi
	fi
fi

[ -L /usr/lib/libssl.so.0.9.8 ] || ln -s /usr/lib/libssl.so.1.0.0 /usr/lib/libssl.so.0.9.8

[ -L /usr/lib/libcrypto.so.0.9.8 ] || ln -s /usr/lib/libcrypto.so.1.0.0 /usr/lib/libcrypto.so.0.9.8

# check if /run directory exists
[ -d /run ] || mkdir /run

# check if media/net directory exists
[ -d /media/net ] || mkdir /media/net

# check if usr/scripts directory exists
[ -d /usr/scripts ] || mkdir /usr/scripts
chmod -R 755 /usr/scripts

# check for settings files
[ -f /etc/enigma2/settings ] || cp /usr/share/enigma2/defaults/* /etc/enigma2/

# any debuglevel passed?
DEBUG_LVL=${ENIGMA_DEBUG_LVL:-4}
ENIGMA_DEBUG_TIME=${ENIGMA_DEBUG_TIME:-2}

#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

#check for specific pagecache helper lib
if [ -e /usr/lib/libpagecache.so ]; then
	LIBS="$LIBS /usr/lib/libpagecache.so"
fi

#check for receiver specific passthrough helper lib
#if [ -e /usr/lib/libpassthrough.so ]; then
#	LIBS="$LIBS /usr/lib/libpassthrough.so"
#fi

touch /etc/enigma2/settings

if [ "$(grep config.crash.enableudevlog /etc/enigma2/settings)" ]; then
	touch /etc/udev/udev.debug &
else
	rm -rf /etc/udev/udev.debug &
fi

if [ -x /usr/bin/showiframe ]; then
	if [[ ! "$stbcheck" =~ "u5" ]]; then
		killall -9 showiframe; sleep 1
	fi
	if [ -f /etc/enigma2/bootlogo.mvi ]; then
		/usr/bin/showiframe /etc/enigma2/bootlogo.mvi
	elif [ -f /usr/share/backdrop.mvi ]; then
		/usr/bin/showiframe /usr/share/backdrop.mvi
	fi
fi

# hook to execute scripts always before enigma2 start
[ -f /usr/bin/enigma2_pre_start.sh ] || echo "#!/bin/sh" > /usr/bin/enigma2_pre_start.sh && chmod -R 755 /usr/bin/enigma2_pre_start.sh
[ -x /usr/bin/enigma2_pre_start.sh ] && /usr/bin/enigma2_pre_start.sh
[ -x /usr/bin/enigma2_pre_start_ciplus.sh ] && /usr/bin/enigma2_pre_start_ciplus.sh

if [ -d /home/root ]; then
	cd /home/root
	export HOME=/home/root
fi

sync
sysctl -p

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
	[ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

VERBOSE=''
if [ "$(grep config.log.level /etc/enigma2/settings)" == "config.log.level=3" ]; then
	DEBUG_LVL='4'
fi

export LC_CTYPE="en_US.UTF-8"

LOGFOLDER="/home/root/logs/"
export LOGFOLDER
if [ "$(grep -i config.crash.enabledebug=true /etc/enigma2/settings)" != "" ]; then
	DEBUG_LVL='4'
	RANDOMIZE1970=''
	time=`date +%Y` ;
	if [ "$time" = 1970 ]; then
		RANDOMIZE1970="$(strings /dev/urandom | grep -o '[[:alnum:]]' | head -n 5 | tr -d '\n')"
	fi
	if [ "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" != "" -a -d "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" ]; then
		LOGFOLDER=$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')
		export LOGFOLDER
	fi
	LOGFILE=${LOGFOLDER}Enigma2-debug-$(date +%Y%m%d_%H-%M-%S)${RANDOMIZE1970}.log
	if [ ! -d $LOGFOLDER ] ; then mkdir -p $LOGFOLDER; fi
	ln -sf ${LOGFILE} ${LOGFOLDER}currlog
	LD_PRELOAD=$LIBS ENIGMA_DEBUG_TIME=${ENIGMA_DEBUG_TIME} ENIGMA_DEBUG_LVL=$DEBUG_LVL /usr/bin/enigma2 2>&1 | tee -a ${LOGFILE}
	ret=${PIPESTATUS[0]}
	ln -sf ${LOGFILE} ${LOGFOLDER}lastlog
else
	LD_PRELOAD=$LIBS ENIGMA_DEBUG_TIME=${ENIGMA_DEBUG_TIME} ENIGMA_DEBUG_LVL=$DEBUG_LVL /usr/bin/enigma2
	ret=$?
fi

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal

if [ "$ret" -ne "1" ]; then
	if [ -e /proc/stb/info/boxtype ]; then
		if [ ${stbcheck:0:2} == "u5" ]; then
			killall -9 showiframe; sleep 5
		fi
		if [ $stbcheck == "sf8008" ] || [ $stbcheck == "sf8008m" ] || [ $stbcheck == "ustym4kpro" ] || [ $stbcheck == "cc1" ] || [ $stbcheck == "trio4k" ] || [ $stbcheck == "gbip4k" ] || [ $stbcheck == "gbmv200" ] || [ $stbcheck == "sfx6008" ]; then
			killall -9 libreader; sleep 5
		fi
	fi
fi

case $ret in
	1)
		/sbin/halt
		;;
	2)
		if [ -f /proc/stb/fp/force_restart ]; then
			echo 1 > /proc/stb/fp/force_restart
		fi
		/sbin/reboot
		;;
	3)
		rm -fR /home/root/.gstreamer-0.10
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	4)
		/sbin/rmmod lcd
		/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
		sleep 1;
		/sbin/rmmod fp
		/sbin/modprobe fp
		/sbin/reboot
		;;
	9)
		sed -i '/config.plugins.configurationbackup.backupdirs/d' /etc/enigma2/settings
		;;
	16)
		if [ -e /dev/block/by-name/bootoptions ]; then
			mkdir -p /tmp/bootoptions
			mount /dev/block/by-name/bootoptions /tmp/bootoptions
			cp -f /tmp/bootoptions/STARTUP_RECOVERY /tmp/bootoptions/STARTUP_ONCE
		else
			echo "rescue" > /proc/stb/fp/boot_mode
		fi
		/sbin/reboot
		;;
	42)
		python /usr/lib/enigma2/python/upgrade.pyc
		;;
	43)
		init 1
		;;
	44)
		# little hack but it will be fixed soon in drivers
		/usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/bin/fbclear
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/wait.mvi
		echo fpupload >/proc/vfd && sleep 3 && dd bs=256k if=/tmp/micom.bin of=/dev/mcu
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/reboot.mvi
		# Wait forever for the user to power off
		while(true) ; do sleep 60 ; done
		;;
	45)
		echo "    " > /dev/lcd0
		/usr/bin/gigablue_wol
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
